<?php
session_start();

// Verifica se a variável de sessão "U" está definida
if (!isset($_SESSION["U"])) {
    // Redireciona para a página de login se o usuário não estiver autenticado
    header("Location: index.php");
    exit;
}

// Obtém o ID do usuário da sessão
$id = $_SESSION['id'];

// Conexão com o banco de dados de usuários
$db = new SQLite3("./api/db/studiolivecode_users.db");

// Conexão com o banco de dados de vencimentos
$dbv = new SQLite3("./api/db/studiolivecode_vencimento.db");

// Faça uma consulta para obter as informações de admin e nível do usuário
$query = $db->query("SELECT admin FROM users WHERE id = $id");
$userData = $query->fetchArray(SQLITE3_ASSOC);

// Verifique se o usuário é administrador (admin = 1) ou tem o nível necessário (por exemplo, nível = 1)
if (!$userData || $userData['admin'] != 1) {
    header("Location: index.php"); // Redirecionar usuários que não têm acesso
    exit;
}

if (isset($_GET["create"])) {
    // Formulário de criação de revenda
    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        // Captura e sanitiza os dados do formulário
        $name = trim($_POST['name']);
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);
        $mac_amount = intval($_POST['mac_amount']);
        $vencimento = $_POST['vencimento'];

        // Validação básica (pode ser expandida conforme necessário)
        if (empty($name) || empty($username) || empty($password) || empty($vencimento)) {
            $mensagem = "Todos os campos são obrigatórios.";
        } else {
            // Consulta para contar o número total de revendas
            $countQuery = "SELECT COUNT(*) as count FROM users WHERE store_type = 1";
            $result = $db->querySingle($countQuery);

            if ($result < 10) {
                // Iniciar uma transação para garantir que ambas as inserções ocorram
                $db->exec("BEGIN TRANSACTION");

                try {
                    // Preparar a inserção do novo usuário
                    $stmt = $db->prepare("INSERT INTO users (name, username, password, logo, mac_amount, store_type, nivel) VALUES (:name, :username, :password, 'img/logo.png', :mac_amount, 1, 2)");
                    $stmt->bindValue(':name', $name, SQLITE3_TEXT);
                    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
                    $stmt->bindValue(':password', $password, SQLITE3_TEXT);
                    $stmt->bindValue(':mac_amount', $mac_amount, SQLITE3_INTEGER);

                    if ($stmt->execute()) {
                        // Obter o último ID inserido
                        $newUserId = $db->lastInsertRowID();

                        // Preparar a inserção do vencimento
                        $stmtVencimento = $dbv->prepare("INSERT INTO vencimento (id, vencimento) VALUES (:id, :vencimento)");
                        $stmtVencimento->bindValue(':id', $newUserId, SQLITE3_INTEGER);
                        $stmtVencimento->bindValue(':vencimento', $vencimento, SQLITE3_TEXT);

                        if ($stmtVencimento->execute()) {
                            // Commit da transação
                            $db->exec("COMMIT");
                            header("Location: revendas.php?r=adicionado");
                            exit;
                        } else {
                            // Rollback em caso de erro
                            $db->exec("ROLLBACK");
                            $mensagem = "Erro ao definir o vencimento da revenda.";
                        }
                    } else {
                        // Rollback em caso de erro
                        $db->exec("ROLLBACK");
                        $mensagem = "Erro ao criar revendedor.";
                    }
                } catch (Exception $e) {
                    // Rollback em caso de exceção
                    $db->exec("ROLLBACK");
                    $mensagem = "Erro ao criar revendedor: " . $e->getMessage();
                }
            } else {
                // Exibir mensagem de erro
                $mensagem = "Limite de 10 Revendas foi atingido. Não é possível criar mais Revendas.";
            }
        }
    }
    include './includes/header.php';
?>
<?php if (!empty($mensagem)): ?>
    <div class='alert alert-danger'><b><?php echo htmlspecialchars($mensagem); ?></b></div>
<?php endif; ?>
<div class="card radius-10">
    <div class="card-body">
        <form method="post">
            <div class="form-group mb-4">
                <label class="control-label" for="name">
                    <strong>Nome</strong>
                </label>
                <input type="text" class="form-control" name="name" placeholder="Nome Revendedor" required />
            </div>
            <div class="form-group mb-4">
                <label class="control-label" for="mac_amount">
                    <strong>Limite de MACs</strong>
                </label>
                <input type="number" class="form-control" name="mac_amount" placeholder="Limite de MACs" min="1" value="1" required />
            </div>
            <div class="form-group mb-4">
                <label class="control-label" for="username">
                    <strong>Usuário</strong>
                </label>
                <input type="text" class="form-control" name="username" placeholder="Usuário" required />
            </div>
            <div class="form-group mb-4">
                <label class="control-label" for="password">
                    <strong>Senha</strong>
                </label>
                <input type="password" class="form-control" name="password" placeholder="Senha" required />
            </div>
            <div class="form-group mb-4">
                <label class="control-label" for="vencimento">
                    <strong>Vencimento</strong>
                </label>
                <input type="date" class="form-control" name="vencimento" required />
            </div>
            <button type="submit" name="submit" class="btn btn-primary mr-2">
                <i class="bx bx-check mr-1"></i> Enviar
            </button>
        </form>
    </div>
</div>
<?php
    include './includes/footer.php';
} elseif (isset($_GET['update'])) {
    // Formulário de atualização de revenda
    $user_id = intval($_GET['update']);

    // Obter dados da revenda
    $query = $db->query("SELECT * FROM users WHERE id = $user_id");
    $userData = $query->fetchArray(SQLITE3_ASSOC);

    // Obter vencimento da revenda
    $stmtVencimento = $dbv->prepare("SELECT vencimento FROM vencimento WHERE id = :id");
    $stmtVencimento->bindValue(':id', $user_id, SQLITE3_INTEGER);
    $resVencimento = $stmtVencimento->execute();
    $vencimentoData = $resVencimento->fetchArray(SQLITE3_ASSOC);

    if (!$userData) {
        header("Location: revendas.php?r=nao_encontrado");
        exit;
    }

    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        // Captura e sanitiza os dados do formulário
        $name = trim($_POST['name']);
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);
        $mac_amount = intval($_POST['mac_amount']);
        $vencimento = $_POST['vencimento'];

        // Validação básica (pode ser expandida conforme necessário)
        if (empty($name) || empty($username) || empty($password) || empty($vencimento)) {
            $mensagem = "Todos os campos são obrigatórios.";
        } else {
            // Iniciar uma transação para garantir que ambas as atualizações ocorram
            $db->exec("BEGIN TRANSACTION");

            try {
                // Preparar a atualização do usuário
                $stmt = $db->prepare("UPDATE users SET name = :name, username = :username, password = :password, mac_amount = :mac_amount WHERE id = :id");
                $stmt->bindValue(':name', $name, SQLITE3_TEXT);
                $stmt->bindValue(':username', $username, SQLITE3_TEXT);
                $stmt->bindValue(':password', $password, SQLITE3_TEXT);
                $stmt->bindValue(':mac_amount', $mac_amount, SQLITE3_INTEGER);
                $stmt->bindValue(':id', $user_id, SQLITE3_INTEGER);

                if ($stmt->execute()) {
                    // Preparar a atualização do vencimento
                    // Verificar se já existe uma entrada de vencimento para este usuário
                    $stmtCheck = $dbv->prepare("SELECT COUNT(*) as count FROM vencimento WHERE id = :id");
                    $stmtCheck->bindValue(':id', $user_id, SQLITE3_INTEGER);
                    $resCheck = $stmtCheck->execute();
                    $countVencimento = $resCheck->fetchArray(SQLITE3_ASSOC)['count'];

                    if ($countVencimento > 0) {
                        // Atualizar vencimento existente
                        $stmtUpdateVencimento = $dbv->prepare("UPDATE vencimento SET vencimento = :vencimento WHERE id = :id");
                        $stmtUpdateVencimento->bindValue(':vencimento', $vencimento, SQLITE3_TEXT);
                        $stmtUpdateVencimento->bindValue(':id', $user_id, SQLITE3_INTEGER);

                        if (!$stmtUpdateVencimento->execute()) {
                            throw new Exception("Erro ao atualizar vencimento.");
                        }
                    } else {
                        // Inserir novo vencimento
                        $stmtInsertVencimento = $dbv->prepare("INSERT INTO vencimento (id, vencimento) VALUES (:id, :vencimento)");
                        $stmtInsertVencimento->bindValue(':id', $user_id, SQLITE3_INTEGER);
                        $stmtInsertVencimento->bindValue(':vencimento', $vencimento, SQLITE3_TEXT);

                        if (!$stmtInsertVencimento->execute()) {
                            throw new Exception("Erro ao inserir vencimento.");
                        }
                    }

                    // Commit da transação
                    $db->exec("COMMIT");
                    header("Location: revendas.php?r=atualizado");
                    exit;
                } else {
                    // Rollback em caso de erro
                    $db->exec("ROLLBACK");
                    $mensagem = "Erro ao atualizar revendedor.";
                }
            } catch (Exception $e) {
                // Rollback em caso de exceção
                $db->exec("ROLLBACK");
                $mensagem = "Erro ao atualizar revendedor: " . $e->getMessage();
            }
        }
    }
    include './includes/header.php';
?>
<?php if (!empty($mensagem)): ?>
    <div class='alert alert-danger'><b><?php echo htmlspecialchars($mensagem); ?></b></div>
<?php endif; ?>
<div class="card radius-10">
    <div class="card-body">
        <form method="post">
            <input type="hidden" name="id" value="<?= htmlspecialchars($user_id) ?>">
            <div class="form-group mb-4">
                <label class="control-label" for="name">
                    <strong>Nome</strong>
                </label>
                <input type="text" class="form-control" name="name" value="<?= htmlspecialchars($userData['name']) ?>" required />
            </div>
            <div class="form-group mb-4">
                <label class="control-label" for="mac_amount">
                    <strong>MACs</strong>
                </label>
                <input type="number" class="form-control" name="mac_amount" value="<?= htmlspecialchars($userData['mac_amount']) ?>" min="1" required />
            </div>
            <div class="form-group mb-4">
                <label class="control-label" for="username">
                    <strong>Usuário</strong>
                </label>
                <input type="text" class="form-control" name="username" value="<?= htmlspecialchars($userData['username']) ?>" required />
            </div>
            <div class="form-group mb-4">
                <label class="control-label" for="password">
                    <strong>Senha</strong>
                </label>
                <input type="password" class="form-control" name="password" value="<?= htmlspecialchars($userData['password']) ?>" required />
            </div>
            <div class="form-group mb-4">
                <label class="control-label" for="vencimento">
                    <strong>Vencimento</strong>
                </label>
                <input type="date" class="form-control" name="vencimento" value="<?= htmlspecialchars(date('Y-m-d', strtotime($vencimentoData['vencimento']))) ?>" required />
            </div>
            <button type="submit" name="submit" class="btn btn-primary mr-2">
                <i class="bx bx-check mr-1"></i> Enviar
            </button>
        </form>
    </div>
</div>
<?php
    include './includes/footer.php';
} elseif (isset($_GET['delete'])) {
    // Excluir revendedor
    $user_id = intval($_GET['delete']);

    // Iniciar uma transação para garantir que ambas as exclusões ocorram
    $db->exec("BEGIN TRANSACTION");

    try {
        // Excluir da tabela de vencimentos
        $stmtDeleteVencimento = $dbv->prepare("DELETE FROM vencimento WHERE id = :id");
        $stmtDeleteVencimento->bindValue(':id', $user_id, SQLITE3_INTEGER);
        $stmtDeleteVencimento->execute();

        // Excluir da tabela de usuários
        $stmtDeleteUser = $db->prepare("DELETE FROM users WHERE id = :id");
        $stmtDeleteUser->bindValue(':id', $user_id, SQLITE3_INTEGER);
        $stmtDeleteUser->execute();

        // Commit da transação
        $db->exec("COMMIT");
        header("Location: revendas.php?r=excluido");
        exit;
    } catch (Exception $e) {
        // Rollback em caso de exceção
        $db->exec("ROLLBACK");
        header("Location: revendas.php?r=erro_exclusao");
        exit;
    }
} else {
    // Tabela principal
    include './includes/header.php';
?>
    <div class="card radius-10">
        <div class="card-header border-bottom-0 bg-transparent">
            <div class="d-flex align-items-center">
                <div>
                    <h5 class="font-weight-bold mb-0">Revendas Cadastradas</h5>
                </div>
                <div class="ms-auto">
                    <a href="revendas.php?create">
                        <button type="button" class="btn btn-white radius-10">Adicionar Revenda</button>
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table mb-0 align-middle">
                    <thead>
                        <tr>
                            <th>Nome</th>
                            <th>Usuário</th>
                            <th>MACs</th>
                            <th>MACs Disponíveis</th>
                            <th>Vencimento</th>
                            <th>Editar</th>
                            <th>Deletar</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $db2 = new SQLite3("./api/db/studiolivecode_clientes.db");
                        $res = $db->query("SELECT * FROM users WHERE (admin != 1 OR admin IS NULL) AND store_type = 1");

                        while ($row = $res->fetchArray(SQLITE3_ASSOC)) {
                            $revenda_id = $row["id"];
                            $name = htmlspecialchars($row["name"]);
                            $username = htmlspecialchars($row["username"]);
                            $macs = intval($row["mac_amount"]);

                            // Obter a contagem de MACs usados
                            $stmtIbo = $db2->prepare("SELECT COUNT(*) as count FROM ibo WHERE id_user = :id_user AND active = 1 AND expire_date > date('now')");
                            $stmtIbo->bindValue(':id_user', $revenda_id, SQLITE3_INTEGER);
                            $resultUsed = $stmtIbo->execute();
                            $macsUsed = $resultUsed->fetchArray(SQLITE3_ASSOC)['count'];
                            $macsAvailable = $macs - $macsUsed;

                            // Obter vencimento da revenda
                            $stmtVencimento = $dbv->prepare("SELECT vencimento FROM vencimento WHERE id = :id");
                            $stmtVencimento->bindValue(':id', $revenda_id, SQLITE3_INTEGER);
                            $resVencimento = $stmtVencimento->execute();
                            $vencimentoData = $resVencimento->fetchArray(SQLITE3_ASSOC);
                            $vencimento = $vencimentoData ? date('d/m/Y', strtotime($vencimentoData['vencimento'])) : 'Não Definido';
                        ?>
                            <tr>
                                <td><?= $name; ?></td>
                                <td><?= $username; ?></td>
                                <td><?= $macs; ?></td>
                                <td><?= $macsAvailable; ?></td>
                                <td><?= $vencimento; ?></td>
                                <td>
                                    <div class="d-flex order-actions">
                                        <a href="revendas.php?update=<?= $revenda_id ?>" class="text-light bg-primary border-0"><i class='bx bxs-edit'></i></a>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex order-actions">
                                        <a class="text-light bg-danger border-0 btn-ok" data-bs-toggle="modal" data-bs-target="#confirm-delete-<?= $revenda_id ?>"><i class="bx bxs-trash"></i></a>
                                    </div>
                                    <!-- Modal -->
                                    <div class="modal fade" id="confirm-delete-<?= $revenda_id ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLabel">Confirmar</h5>
                                                </div>
                                                <div class="modal-body">Você realmente deseja excluir?</div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Não</button>
                                                    <a href="revendas.php?delete=<?= $revenda_id ?>" class="btn btn-danger btn-ok">Sim</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        <?php
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php
    include './includes/footer.php';
}
if (isset($_GET["r"])) {
    $result = $_GET["r"];
    switch ($result) {
        case "adicionado":
            echo "<script>
            const Toast = Swal.mixin({
              toast: true,
              position: 'bottom',
              showConfirmButton: false,
              timer: 2000,
            })
            Toast.fire({
              icon: 'success',
              title: 'Revendedor Adicionado com Sucesso!'
            })</script>";
            break;
        case "excluido":
            echo "<script>
            const Toast = Swal.mixin({
              toast: true,
              position: 'bottom',
              showConfirmButton: false,
              timer: 2000,
            })
            Toast.fire({
              icon: 'success',
              title: 'Revendedor Excluído com Sucesso!'
            })</script>";
            break;
        case "atualizado":
            echo "<script>
            const Toast = Swal.mixin({
              toast: true,
              position: 'bottom',
              showConfirmButton: false,
              timer: 2000,
            })
            Toast.fire({
              icon: 'success',
              title: 'Revendedor Atualizado com Sucesso!'
            })</script>";
            break;
        case "nao_encontrado":
            echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Revendedor Não Encontrado',
                text: 'O revendedor que você tentou editar não foi encontrado.',
            })</script>";
            break;
        case "erro_exclusao":
            echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Erro na Exclusão',
                text: 'Ocorreu um erro ao tentar excluir o revendedor. Por favor, tente novamente.',
            })</script>";
            break;
    }
}
?>
