<?php
session_start();

// Verifica se a variável de sessão "U" está definida
if (!isset($_SESSION["U"])) {
    // Redireciona para a página de login se o usuário não estiver autenticado
    header("location: index.php");
    exit;
}

// Conexão com o banco de dados de usuários
$dbcheckss = new SQLite3("./api/db/studiolivecode_users.db");
$username_check = SQLite3::escapeString($_SESSION["U"]);
$rescheckss = $dbcheckss->prepare("SELECT * FROM users WHERE username = :username");
$rescheckss->bindValue(':username', $username_check, SQLITE3_TEXT);
$resultCheck = $rescheckss->execute();
$rowcheckss = $resultCheck->fetchArray(SQLITE3_ASSOC);

// Verifica se o usuário está autorizado e obtem informações do usuário
if (!$rowcheckss) {
    // Redireciona para a página de login se não encontrar o usuário
    header("location: index.php");
    exit;
}

// Armazena as informações do usuário em variáveis
$name_header = htmlspecialchars($rowcheckss['name']);
$username_check2 = htmlspecialchars($rowcheckss["username"]);
$logo_header = htmlspecialchars($rowcheckss['logo']);
$nivel_header = intval($rowcheckss['nivel']);
$creditos = intval($rowcheckss['mac_amount']); // MACs totais disponíveis para esta revenda

// Obtém o ID do usuário da sessão
$id = intval($rowcheckss['id']);

// Fecha a conexão com o banco de dados de usuários
$dbcheckss->close();

// Obtém a parte da URL atual
$dircheck = substr($_SERVER["REQUEST_URI"], 0, strrpos($_SERVER["REQUEST_URI"], "/"));
$dircheck2 = substr($dircheck, 1);

// Cria uma variável para verificar a autorização
$valid = $username_check . $dircheck2;

// Verifica se o usuário está autorizado
if (!isset($_SESSION[$valid])) {
    // Redireciona para a página de login se não estiver autorizado
    header("location: index.php");
    exit;
}

// Função para inicializar o banco de dados
function initializeDatabase($dbPath, $tableName, $tableStructure) {
    $db = new SQLite3($dbPath);
    $db->exec("CREATE TABLE IF NOT EXISTS $tableName $tableStructure");
    return $db;
}

// Inicializa a tabela 'ibo' no banco de dados 'clientes.db'
$dbans = initializeDatabase("./api/db/studiolivecode_clientes.db", "ibo", "(
    id INTEGER PRIMARY KEY NOT NULL,
    mac_address VARCHAR(17),
    username VARCHAR(100),
    password VARCHAR(100),
    expire_date VARCHAR(10),
    dns VARCHAR(100),
    epg_url VARCHAR(100),
    title VARCHAR(100),
    url VARCHAR(100),
    type INTEGER,
    id_user INTEGER,
    active INTEGER
)");

// Inicializa a tabela 'vencimento' no banco de dados 'vencimento.db'
$dbv = initializeDatabase("./api/db/studiolivecode_vencimento.db", "vencimento", "(
    id INTEGER PRIMARY KEY,
    vencimento TEXT
)");

// Verifica se o usuário possui um registro de vencimento
$stmtCheckVencimento = $dbv->prepare("SELECT vencimento FROM vencimento WHERE id = :id");
$stmtCheckVencimento->bindValue(':id', $id, SQLITE3_INTEGER);
$resv = $stmtCheckVencimento->execute();
$rowv = $resv->fetchArray(SQLITE3_ASSOC);

// Apenas lê a data de vencimento, não insere automaticamente
if ($rowv) {
    $vencimento = $rowv["vencimento"];
} else {
    $vencimento = null; // Vencimento não definido
}

// Inicializa a tabela 'theme' no banco de dados 'clientes.db'
$dbans->exec("CREATE TABLE IF NOT EXISTS theme(id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, name VARCHAR(100), url VARCHAR(100))");
$rows = $dbans->query("SELECT COUNT(*) as count FROM theme");
$rowt = $rows->fetchArray(SQLITE3_ASSOC);
$numRowst = intval($rowt["count"]);
if ($numRowst == 0) {
    $dbans->exec("INSERT INTO theme(name,url) VALUES('Default','')");
}

// Contagens de MACs
$mac_count = intval($dbans->querySingle("SELECT COUNT(*) as count FROM ibo WHERE id_user = $id"));
$mac_used_by_revenda = $mac_count; // O mac_count já é o total de MACs usados por essa revenda
$mac_available = $creditos - $mac_used_by_revenda; // Calcula os MACs disponíveis

$all_mac_count = intval($dbans->querySingle("SELECT COUNT(*) as count FROM ibo"));
$test_mac_count = intval($dbans->querySingle("SELECT COUNT(*) as count FROM ibo WHERE active = 0"));

// Conexão adicional com o banco de dados de usuários para obter informações específicas
$dbpans = new SQLite3("./api/db/studiolivecode_users.db");
$countQuery = "SELECT COUNT(*) as count FROM users WHERE store_type = 1";
$rev_count = intval($dbpans->querySingle($countQuery));
$resans = $dbpans->prepare("SELECT * FROM users WHERE id = :id");
$resans->bindValue(':id', $id, SQLITE3_INTEGER);
$resultAns = $resans->execute();
$rowans = $resultAns->fetchArray(SQLITE3_ASSOC);
$nameans = htmlspecialchars($rowans["name"]);
$logoans = htmlspecialchars($rowans["logo"]);
$nivel_admin = intval($rowans["admin"]);
?>

<!doctype html>
<html lang="en" class="color-sidebar">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="assets/images/logo.png" type="image/png" />
    <link href="assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet" />
    <link href="assets/css/pace.min.css" rel="stylesheet" />
    <script src="assets/js/pace.min.js"></script>
    <link href="assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">
    <link href="assets/css/geral.css" rel="stylesheet">
    <link href="assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/tema-escuro.css" />
    <link rel="stylesheet" href="assets/css/semi-dark.css" />
    <link rel="stylesheet" href="assets/css/cores-do-menu.css" />
    <link rel="stylesheet" href="assets/css/apps_styles.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@sweetalert2/theme-default/default.css" />
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href='https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css' rel='stylesheet'>
    <title>Painel Ibo Revenda</title>
    <meta content="./assets/images/logo.png" property="og:image" />
<style>
    .blink {
        animation: blinker 1s linear infinite;
        color: red !important; /* Força a cor vermelha */
    }
    @keyframes blinker {
        50% {
            opacity: 0;
        }
    }
</style>
</head>

<body>
    <div class="wrapper">
        <div class="sidebar-wrapper" data-simplebar="true">
            <div class="sidebar-header">
                <div>
                    <img src="assets/images/logo.png" class="logo-icon" alt="logo icon">
                </div>
                <div>
                    <h4 class="logo-text">Ibo Revenda</h4>
                </div>
                <div class="toggle-icon ms-auto"><i class='bx bx-menu'></i>
                </div>
            </div>
            <ul class="metismenu" id="menu">
               <?php if ($nivel_admin == 1) { ?>                 <li>
                    <a href="estatisticas.php">
                        <div class="parent-icon"><i class='bx bx-play'></i></div>
                        <div class="menu-title">Estatisticas</div>
                    </a>
                </li><?php } ?>
                                <li>
                    <a href="./api/payment/payment_go.php" target="_blank" rel="noopener noreferrer">
                        <div class="parent-icon"><i class='bx bx-dollar'></i></div>
                        <div class="menu-title">Link Renovação</div>
                    </a>
                </li>
              

  <?php if ($nivel_admin == 1) { ?>

                    <li>
                        <a href="teste.php">
                            <div class="parent-icon"><i class='bx bx-bot'></i>
                            </div>
                            <div class="menu-title">Chatbot</div>
                        </a>
                    </li>
<?php } ?>

                <li class="menu-label">Cadastros</li>
                
                                <li>
                    <a href="users_teste.php">
                        <div class="parent-icon"><i class='bx bx-user-voice'></i>
                        </div>
                        <div class="menu-title">Adicionar Cliente (<?php echo $test_mac_count; ?>)</div>
                    </a>
                </li>
                
                <li>
                    <a href="users.php">
                        <div class="parent-icon"><i class='bx bx-user-circle'></i>
                        </div>
                        <div class="menu-title">Meus Clientes (<?php echo $mac_count; ?>)</div>
                    </a>
                </li>

                                <li>
                    <a href="gestor.php" target="_blank" rel="noopener noreferrer">
                        <div class="parent-icon"><i class='bx bx-dollar'></i></div>
                        <div class="menu-title">Gestor Clientes</div>
                    </a>
                </li>
                
                <?php if ($nivel_admin == 1) { ?>
                
                
                    <li>
                        <a href="all_users.php">
                            <div class="parent-icon"><i class='bx bxs-user-account'></i>
                            </div>
                            <div class="menu-title">Todos Usuários (<?php echo $all_mac_count; ?>)</div>
                        </a>
                    </li>
                    <li>
                        <a href="revendas.php">
                            <div class="parent-icon"><i class="bx bxs-user-account"></i></div>
                            <div class="menu-title">Revendedores</div>
                        </a>
                    </li>
                    
                                     <li>
                        <a href="dns.php">
                            <div class="parent-icon"><i class='bx bx-server'></i>
                            </div>
                            <div class="menu-title">DNS</div>
                        </a>
                    </li>
                    
                    <li>
                        <a href="migrar_dns.php">
                        <div class="parent-icon"><i class='bx bx-server'></i>
                        </div>
                        <div class="menu-title">Migrar DNS Massa</div>
                        </a>
                    </li>

                    <li class="menu-label">Customizar</li>

                    
                    <?php } ?>
                    

                    <?php if ($nivel_admin == 1) { ?>
                    <li>

                        <a href="tema.php">
                            <div class="parent-icon"><i class='bx bx-palette'></i></div>
                            <div class="menu-title">Temas</div>
                        </a>
                    </li>
                    <li>
                        <a href="logo.php">
                            <div class="parent-icon"><i class='bx bx-image'></i>
                            </div>
                            <div class="menu-title">Logo</div>
                        </a>
                    </li>
                    <li>
                        <a href="bg.php">
                            <div class="parent-icon"><i class='bx bx-minus-back'></i>
                            </div>
                            <div class="menu-title">Fundo</div>
                        </a>
                    </li>
  
                    <li>
                        <a href="qrcode.php">
                            <div class="parent-icon"><i class='bx bx-qr'></i>
                            </div>
                            <div class="menu-title">QR Code</div>
                        </a>
                    </li>
                    <li>
                        <a href="contato.php">
                            <div class="parent-icon"><i class='bx bx-phone'></i>
                            </div>
                            <div class="menu-title">Contato no app</div>
                        </a>
                    </li>

                    <li>
                        <a href="note.php">
                            <div class="parent-icon"><i class='bx bx-message-detail'></i>
                            </div>
                            <div class="menu-title">Mensagem no app</div>
                        </a>
                    </li>
   
                    
                <?php } ?>
                <li class="menu-label">Administrador</li>
                <li>
                    <a href="usuario.php">
                        <div class="parent-icon"><i class='bx bx-user'></i>
                        </div>
                        <div class="menu-title">Editar Perfil</div>
                    </a>
                </li>
                <?php if ($nivel_header == 1) { ?>
                    <li>
                        <a href="usuarios.php">
                            <div class="parent-icon"><i class='bx bx-user'></i>
                            </div>
                            <div class="menu-title">Usuários</div>
                        </a>
                    </li>
                <?php } ?>


                </li>
                <?php if ($nivel_header == 1) { ?>
                    <li class="menu-label">Vencimento</li>
                    <li>
                        <a href="admins.php">
                            <div class="parent-icon"><i class="bx bxs-user-account"></i></div>
                            <div class="menu-title">Vencimento admin</div>
                        </a>
                    </li>
                    <li>
                        <a href="vencimento.php">
                            <div class="parent-icon"><i class='bx bx-hourglass'></i>
                            </div>
                            <div class="menu-title">Vencimento</div>
                        </a>
                    </li>
                <?php } ?>
                <li class="menu-label">Sair</li>
                <li>
                    <a href="sair.php">
                        <div class="parent-icon"><i class='bx bx-exit'></i>
                        </div>
                        <div class="menu-title">Sair</div>
                    </a>
                </li>
                </ul>
        </div>
        <header>
            <div class="topbar d-flex align-items-center">
                <nav class="navbar navbar-expand">
                    <div class="mobile-toggle-menu"><i class='bx bx-menu'></i>
                    </div>

                    <div class="marquee">
                        <div class="marquee-content">
                            <span id="vencimento-text"></span>
                        </div>
                    </div>
                    <div class="top-menu ms-auto">
                        <ul class="navbar-nav align-items-center">
                            <li class="nav-item dropdown dropdown-large">
                                <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"> <i class='bx bx-category'></i>
                                </a>
                                <div class="dropdown-menu dropdown-menu-end">
                                    <div class="row row-cols-3 g-3 p-3">
                                        </div>
                                </div>
                            </li>
                            <li class="nav-item dropdown dropdown-large">
                                <div class="dropdown-menu dropdown-menu-end">
                                    <div class="header-notifications-list">
                                        </div>
                                    <a href="javascript:;">
                                        <div class="text-center msg-footer">View All Notifications</div>
                                    </a>
                                </div>
                            </li>
                            <li class="nav-item dropdown dropdown-large">
                                <div class="dropdown-menu dropdown-menu-end">
                                    <div class="header-message-list">
                                        </div>
                                    <a href="javascript:;">
                                        <div class="text-center msg-footer">View All Messages</div>
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </header>
<script>
    document.addEventListener("DOMContentLoaded", function() {
        var vencimentoText = document.getElementById('vencimento-text');
        <?php
        if ($nivel_admin == 1) {
            // Se for admin, exibe a mensagem fixa
            echo 'vencimentoText.innerHTML = "Painel Ibo Revenda Gestor";';
        } else {
            // Se for revenda, mostra a saudação e os MACs
            $nomeRevenda = $name_header; // Já temos o nome da revenda na variável $name_header
            $macsTotais = $creditos; // MACs totais disponíveis para esta revenda
            $macsUsados = $mac_used_by_revenda; // MACs usados por esta revenda
            $macsDisponiveis = $mac_available; // MACs disponíveis

            if ($vencimento) {
                $dataAtual = new DateTime();
                $dataVencimento = new DateTime($vencimento);
                $diasRestantes = $dataAtual->diff($dataVencimento)->format('%r%a');
                
                $mensagemVencimento = "";
                if ($diasRestantes <= -1) {
                    $mensagemVencimento = "Seu painel está BLOQUEADO! Renove Agora!";
                } else {
                    $mensagemVencimento = "Seu acesso vence em: " . $diasRestantes . " dias!";
                }
                
                // Aplica a classe 'blink' se dias restantes forem 1, 2, 3, 4 ou 5
                if ($diasRestantes > -1 && $diasRestantes <= 5) {
                    echo 'vencimentoText.classList.add("blink");';
                }
                echo 'vencimentoText.innerHTML = "Olá ' . $nomeRevenda . ', ' . $mensagemVencimento . ' - MACs Totais: ' . $macsTotais . ' -- MACs Disponíveis: ' . $macsDisponiveis . '";';
            } else {
                // Se não tiver vencimento definido, ainda mostra os dados de MACs
                echo 'vencimentoText.innerHTML = "Olá ' . $nomeRevenda . ', Painel Ibo Full Revenda - MACs Totais: ' . $macsTotais . '             - MACs Disponíveis: ' . $macsDisponiveis . '";';
            }
        }
        ?>
    });
</script>

        <div class="page-wrapper">
            <div class="page-content">
                </div>