<?php
// Determinar o domínio atual dinamicamente
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$domain = $_SERVER['HTTP_HOST'];

// Pegar o caminho completo da requisição
$requestUri = $_SERVER['REQUEST_URI'];

// Extrair o caminho relativo até a raiz (removendo o nome do arquivo atual e a pasta /api)
$basePath = dirname($requestUri);
$rootPath = str_replace('/api', '', $basePath); // Remove /api do caminho
$rootPath = $rootPath === '/' ? '' : $rootPath; // Ajusta para evitar barra dupla

// Construir a URL completa para renovar.php antes da pasta /api
$paymentUrl = $protocol . $domain . ($rootPath ? '/' . ltrim($rootPath, '/') : '') . '/api/payment/payment_go.php';

// Gerar a URL do QR Code usando a API do qrserver.com
$qrCodeUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode($paymentUrl);
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>Renovar QR Code</title>
    <style>
        body {
            background-color: #040710;
            color: #fff;
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        .container {
            text-align: center;
            padding: 5px;
            width: 90%;
            max-width: 400px; /* Reduzido para melhor proporção */
            max-height: 90vh;
            box-sizing: border-box;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        h2 {
            color: #dbb953;
            font-size: clamp(0.8rem, 2vw, 1rem);
            margin: 0;
            line-height: 1.3;
        }
        .qr-code {
            padding: 0;
            border-radius: 0;
            background: transparent;
            max-width: 100%;
            max-height: 40vh;
        }
        .qr-code img {
            display: block;
            width: 100%;
            max-width: 120px; /* Tamanho menor para melhor proporção */
            max-height: 120px;
            height: auto;
            margin: 0 auto;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Confira nossas promoções!</h2>
        <div class="qr-code">
            <img src="<?php echo $qrCodeUrl; ?>" alt="QR Code para Pagamento">
        </div>
    </div>
</body>
</html>