<!DOCTYPE HTML>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ativar / Renovar</title>

    <style>
        body {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            height: 100vh;
            margin: 0;
            background-color: #7b6e5e;
            color: white;
            font-family: Arial, sans-serif;
        }

        h1 {
            text-align: center;
            animation: blinkText 1.5s infinite alternate;
        }

        @keyframes blinkText {
            0% { color: white; }
            50% { color: yellow; }
            100% { color: white; }
        }

        .box img {
            width: 200px;
            height: 200px;
            border-radius: 10px;
            animation: blinkImage 1s infinite alternate;
        }

        @keyframes blinkImage {
            0% { opacity: 1; }
            50% { opacity: 0.5; }
            100% { opacity: 1; }
        }
    </style>
</head>
<body>

<?php
    // Detecta protocolo e domínio
    $protocolo = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    $dominio = $_SERVER['HTTP_HOST'];

    // Caminho atual sem o último segmento (ex: remove /api)
    $uri = rtrim(dirname($_SERVER['REQUEST_URI']), '/');
    $uriPai = substr($uri, 0, strrpos($uri, '/')); // Remove o último segmento

    // URL final apontando para a raiz de onde está o pagamento.php
    $url = $protocolo . $dominio . $uriPai . '/api/payment/payment_go.php';
?>

<h1>Escanei o QR Code para Ativar seu Acesso!</h1>

<div class="box">
    <img src="https://image-charts.com/chart?chs=300x300&cht=qr&chl=<?= urlencode($url) ?>" alt="QR Code">
</div>

</body>
</html>
