<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>flix-play.com/apks</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            position: relative;
            height: 100vh;
            background-color: #222;
            display: flex;
            justify-content: center;
            align-items: center;
            overflow: hidden;
        }
        .backdrop-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            overflow: hidden;
            z-index: -1;
        }
        .backdrop {
            width: 100%;
            height: 100%;
            object-fit: cover;
            position: absolute;
            opacity: 0;
            transition: opacity 2s ease-in-out;
        }

        .backdrop.visible {
            opacity: 1;
        }

        .logo {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            max-width: 300px;
            max-height: 150px;
            opacity: 0;
            transition: opacity 1s ease-in-out;
        }

        .logo.visible {
            opacity: 1;
        }
    </style>
</head>
<body>
    <div class="backdrop-container">
        <img id="backdrop1" class="backdrop">
        <img id="backdrop2" class="backdrop">
    </div>
    <img id="logo" class="logo">

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2';
        let currentIndex = 0;
        let movieIds = [];
        let isBackdrop1Visible = true;

        async function fetchPopularMovieIds() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&sort_by=popularity.desc&language=pt`);
                if (!response.ok) throw new Error('Failed to fetch popular movies');
                const data = await response.json();
                movieIds = data.results.map(movie => movie.id);
            } catch (error) {
                console.error('Error fetching popular movies:', error);
            }
        }

        async function fetchMovieAssets(movieId) {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/${movieId}/images?api_key=${apiKey}`);
                if (!response.ok) throw new Error('Failed to fetch movie images');
                const data = await response.json();
                const backdropPath = data.backdrops[0]?.file_path;
                
                // Prioriza logos em português do Brasil (pt-BR), senão pega qualquer outro disponível
                const logoPath = data.logos.find(logo => logo.iso_639_1 === 'pt-BR')?.file_path ||
                                 data.logos.find(logo => logo.iso_639_1 === 'en')?.file_path ||
                                 data.logos[0]?.file_path;
                
                return {
                    backdrop: backdropPath ? `https://image.tmdb.org/t/p/original${backdropPath}` : null,
                    logo: logoPath ? `https://image.tmdb.org/t/p/w500${logoPath}` : null
                };
            } catch (error) {
                console.error('Error fetching movie assets:', error);
                return { backdrop: null, logo: null };
            }
        }

        async function updateBackdrop() {
            if (movieIds.length === 0) return;
            const movieId = movieIds[currentIndex];
            const backdrop1 = document.getElementById('backdrop1');
            const backdrop2 = document.getElementById('backdrop2');
            const logo = document.getElementById('logo');

            const currentBackdrop = isBackdrop1Visible ? backdrop1 : backdrop2;
            const nextBackdrop = isBackdrop1Visible ? backdrop2 : backdrop1;

            const { backdrop, logo: logoUrl } = await fetchMovieAssets(movieId);

            if (backdrop) {
                nextBackdrop.src = backdrop;
                nextBackdrop.onload = () => {
                    currentBackdrop.classList.remove('visible');
                    nextBackdrop.classList.add('visible');
                };
            }

            setTimeout(() => {
                if (logoUrl) {
                    logo.src = logoUrl;
                    logo.classList.add('visible');
                    setTimeout(() => logo.classList.remove('visible'), 2000);
                }
            }, 4000); // A logo aparece 4 segundos após a transição

            currentIndex = (currentIndex + 1) % movieIds.length;
            isBackdrop1Visible = !isBackdrop1Visible;
        }

        fetchPopularMovieIds().then(() => {
            setInterval(updateBackdrop, 9000);
            updateBackdrop();
        });
    </script>
</body>
</html>
