<?php
$api_key = '6b8e3eaa1a03ebb45642e9531d8a76d2';
$url = "https://api.themoviedb.org/3/trending/movie/week?api_key=$api_key&language=pt-BR";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

$data = json_decode($response, true);
$movies = array_slice($data['results'], 0, 5);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8">
  <title>Flix Play</title>
  <style>
    * { margin:0; padding:0; box-sizing:border-box; }
    body, html {
      width:100%; height:100%; overflow:hidden;
      background:#000;
    }
    main {
      position:relative;
      width:100%; height:100vh;
    }
    .movie-slide {
      position:absolute;
      top:0; left:0;
      width:100%; height:100%;
      background-size:cover;
      background-position:center;
      opacity:0;
      transition:opacity 1s ease-in-out;
    }
    .movie-slide::before {
      content: "";
      position: absolute;
      top: 0; left: 0;
      width: 100%; height: 100%;
      background: rgba(0,0,0,0.6);
      z-index: 0;
    }
    .movie-slide.active { opacity:1; }
    .poster {
      position:absolute;
      top:50%; left:50%;
      width:250px;
      transform: translate(-50%, -50%) rotateY(-10deg);
      transition:transform 0.5s;
      perspective:1000px;
      z-index: 1;
    }
    .poster img {
      width:100%; height:auto;
      border-radius:8px;
      box-shadow:0 0 15px rgba(0,0,0,0.6);
    }
    .poster:hover { transform: translate(-50%, -50%) rotateY(0) scale(1.1); }
  </style>
</head>
<body>
  <main>
    <?php foreach($movies as $i => $movie):
      $bg = 'https://image.tmdb.org/t/p/original'.$movie['backdrop_path'];
      $poster = 'https://image.tmdb.org/t/p/w500'.$movie['poster_path'];
    ?>
      <div class="movie-slide<?= $i===0? ' active':'' ?>" style="background-image:url('<?= $bg ?>')">
        <div class="poster">
          <img src="<?= $poster ?>" alt="Poster">
        </div>
      </div>
    <?php endforeach; ?>
  </main>

  <script>
    document.addEventListener('DOMContentLoaded', () => {
      const slides = document.querySelectorAll('.movie-slide');
      let idx = 0;
      setInterval(() => {
        slides[idx].classList.remove('active');
        idx = (idx+1)%slides.length;
        slides[idx].classList.add('active');
      }, 10000);
    });
  </script>
</body>
</html>